//
//  CRPhotoViewBase.h
//  CRGraphics
//
//  Created by Yaroslav Glushchenko on 04/04/10
//  Copyright 2009 Corner-A. All rights reserved.
//

@class CRInplaceEditorController;

//////////////////////////////////////////////////////////////////////
// Complex PhotoView visual object, render the image, provides data
// and notifications for image editors
//////////////////////////////////////////////////////////////////////
@interface CRPhotoViewBase : NSClipView 
{
@protected
	BOOL								isConnected;
	CRInplaceEditorController* assigned	activeEditor;
}

@property (nonatomic, assign) CRInplaceEditorController*	activeEditor;
@property (nonatomic, strong) NSPasteboard*					droppedData;

- (NSSize)spacing;
- (void)disconnect;

@end